<?php

namespace Snapfile\Entities;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;
    protected $fillable = array('user_id', 'service_profile_id');
    protected $visible = array('user_id', 'service_profile_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function serviceProfile()
    {
        return $this->belongsTo('Snapfile\Entities\Business\ServiceProfile', 'service_profile_id');
    }

}